/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.fluids;

import com.google.common.collect.ImmutableMap;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.fluids.PortingLibFluids;
import io.github.fabricators_of_create.porting_lib.fluids.sound.SoundAction;
import io.github.fabricators_of_create.porting_lib.fluids.sound.SoundActions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class FluidType {
    private String descriptionId;
    private final double motionScale;
    private final boolean canPushEntity;
    private final boolean canSwim;
    private final boolean canDrown;
    private final float fallDistanceModifier;
    private final boolean canExtinguish;
    private final boolean canConvertToSource;
    private final boolean supportsBoating;
    @Nullable
    private final class_7 pathType;
    @Nullable
    private final class_7 adjacentPathType;
    private final boolean canHydrate;
    private final int lightLevel;
    private final int density;
    private final int temperature;
    private final int viscosity;
    private final class_1814 rarity;
    protected final Map<SoundAction, class_3414> sounds;
    private Object renderProperties;

    public FluidType(Properties properties) {
        this.descriptionId = properties.descriptionId;
        this.motionScale = properties.motionScale;
        this.canPushEntity = properties.canPushEntity;
        this.canSwim = properties.canSwim;
        this.canDrown = properties.canDrown;
        this.fallDistanceModifier = properties.fallDistanceModifier;
        this.canExtinguish = properties.canExtinguish;
        this.canConvertToSource = properties.canConvertToSource;
        this.supportsBoating = properties.supportsBoating;
        this.pathType = properties.pathType;
        this.adjacentPathType = properties.adjacentPathType;
        this.sounds = ImmutableMap.copyOf(properties.sounds);
        this.canHydrate = properties.canHydrate;
        this.lightLevel = properties.lightLevel;
        this.density = properties.density;
        this.temperature = properties.temperature;
        this.viscosity = properties.viscosity;
        this.rarity = properties.rarity;
    }

    public class_2561 getDescription() {
        return class_2561.method_43471((String)this.getDescriptionId());
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = class_156.method_646((String)"fluid_type", (class_2960)PortingLibFluids.FLUID_TYPES.method_10221((Object)this));
        }
        return this.descriptionId;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public int getDensity() {
        return this.density;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getViscosity() {
        return this.viscosity;
    }

    public class_1814 getRarity() {
        return this.rarity;
    }

    @Nullable
    public class_3414 getSound(SoundAction action) {
        return this.sounds.get(action);
    }

    public double motionScale(class_1297 entity) {
        return this.motionScale;
    }

    public boolean canPushEntity(class_1297 entity) {
        return this.canPushEntity;
    }

    public boolean canSwim(class_1297 entity) {
        return this.canSwim;
    }

    public float getFallDistanceModifier(class_1297 entity) {
        return this.fallDistanceModifier;
    }

    public boolean canExtinguish(class_1297 entity) {
        return this.canExtinguish;
    }

    public boolean move(class_3610 state, class_1309 entity, class_243 movementVector, double gravity) {
        return false;
    }

    public boolean canDrownIn(class_1309 entity) {
        return this.canDrown;
    }

    public void setItemMovement(class_1542 entity) {
        class_243 vec3 = entity.method_18798();
        entity.method_18800(vec3.field_1352 * (double)0.99f, vec3.field_1351 + (double)(vec3.field_1351 < (double)0.06f ? 5.0E-4f : 0.0f), vec3.field_1350 * (double)0.99f);
    }

    public boolean supportsBoating(class_1690 boat) {
        return this.supportsBoating;
    }

    public boolean supportsBoating(class_3610 state, class_1690 boat) {
        return this.supportsBoating(boat);
    }

    public boolean canRideVehicleUnder(class_1297 vehicle, class_1297 rider) {
        if (this == PortingLibFluids.WATER_TYPE) {
            return !vehicle.method_49693();
        }
        return true;
    }

    public boolean canHydrate(class_1297 entity) {
        return this.canHydrate;
    }

    @Nullable
    public class_3414 getSound(class_1297 entity, SoundAction action) {
        return this.getSound(action);
    }

    public boolean canExtinguish(class_3610 state, class_1922 getter, class_2338 pos) {
        return this.canExtinguish;
    }

    public boolean canConvertToSource(class_3610 state, class_4538 reader, class_2338 pos) {
        return this.canConvertToSource;
    }

    @Nullable
    public class_7 getBlockPathType(class_3610 state, class_1922 level, class_2338 pos, @Nullable class_1308 mob, boolean canFluidLog) {
        return this.pathType;
    }

    @Nullable
    public class_7 getAdjacentBlockPathType(class_3610 state, class_1922 level, class_2338 pos, @Nullable class_1308 mob, class_7 originalType) {
        return this.adjacentPathType;
    }

    @Nullable
    public class_3414 getSound(@Nullable class_1657 player, class_1922 getter, class_2338 pos, SoundAction action) {
        return this.getSound(action);
    }

    public boolean canHydrate(class_3610 state, class_1922 getter, class_2338 pos, class_2680 source, class_2338 sourcePos) {
        return this.canHydrate;
    }

    public int getLightLevel(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getLightLevel();
    }

    public int getDensity(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getDensity();
    }

    public int getTemperature(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getTemperature();
    }

    public int getViscosity(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.getViscosity();
    }

    public boolean canConvertToSource(FluidStack stack) {
        return this.canConvertToSource;
    }

    @Nullable
    public class_3414 getSound(FluidStack stack, SoundAction action) {
        return this.getSound(action);
    }

    public class_2561 getDescription(FluidStack stack) {
        return class_2561.method_43471((String)this.getDescriptionId(stack));
    }

    public String getDescriptionId(FluidStack stack) {
        return this.getDescriptionId();
    }

    public boolean canHydrate(FluidStack stack) {
        return this.canHydrate;
    }

    public int getLightLevel(FluidStack stack) {
        return this.getLightLevel();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public class_1814 getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public final boolean isAir() {
        return this == PortingLibFluids.EMPTY_TYPE;
    }

    public final boolean isVanilla() {
        return this == PortingLibFluids.LAVA_TYPE || this == PortingLibFluids.WATER_TYPE;
    }

    public class_1799 getBucket(FluidStack stack) {
        return new class_1799((class_1935)stack.getFluid().method_15774());
    }

    public class_2680 getBlockForFluidState(class_1920 getter, class_2338 pos, class_3610 state) {
        return state.method_15759();
    }

    public class_3610 getStateForPlacement(class_1920 getter, class_2338 pos, FluidStack stack) {
        return stack.getFluid().method_15785();
    }

    public final boolean canBePlacedInLevel(class_1920 getter, class_2338 pos, class_3610 state) {
        return !this.getBlockForFluidState(getter, pos, state).method_26215();
    }

    public final boolean canBePlacedInLevel(class_1920 getter, class_2338 pos, FluidStack stack) {
        return this.canBePlacedInLevel(getter, pos, this.getStateForPlacement(getter, pos, stack));
    }

    public final boolean isLighterThanAir() {
        return this.getDensity() <= 0;
    }

    public boolean isVaporizedOnPlacement(class_1937 level, class_2338 pos, FluidStack stack) {
        if (level.method_8597().comp_644()) {
            return this == PortingLibFluids.WATER_TYPE || this.getStateForPlacement((class_1920)level, pos, stack).method_15767(class_3486.field_15517);
        }
        return false;
    }

    public void onVaporize(@Nullable class_1657 player, class_1937 level, class_2338 pos, FluidStack stack) {
        class_3414 sound = this.getSound(player, (class_1922)level, pos, SoundActions.FLUID_VAPORIZE);
        level.method_8396(player, pos, sound != null ? sound : class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.method_8494((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public String toString() {
        @Nullable class_2960 name = PortingLibFluids.FLUID_TYPES.method_10221((Object)this);
        return name != null ? name.toString() : "Unregistered FluidType";
    }

    public Object getRenderPropertiesInternal() {
        return this.renderProperties;
    }

    public static final class Properties {
        private String descriptionId;
        private double motionScale = 0.014;
        private boolean canPushEntity = true;
        private boolean canSwim = true;
        private boolean canDrown = true;
        private float fallDistanceModifier = 0.5f;
        private boolean canExtinguish = false;
        private boolean canConvertToSource = false;
        private boolean supportsBoating = false;
        @Nullable
        private class_7 pathType = class_7.field_18;
        @Nullable
        private class_7 adjacentPathType = class_7.field_4;
        private final Map<SoundAction, class_3414> sounds = new HashMap<SoundAction, class_3414>();
        private boolean canHydrate = false;
        private int lightLevel = 0;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private class_1814 rarity = class_1814.field_8906;

        private Properties() {
        }

        public static Properties create() {
            return new Properties();
        }

        public Properties descriptionId(String descriptionId) {
            this.descriptionId = descriptionId;
            return this;
        }

        public Properties motionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public Properties canPushEntity(boolean canPushEntity) {
            this.canPushEntity = canPushEntity;
            return this;
        }

        public Properties canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        public Properties canDrown(boolean canDrown) {
            this.canDrown = canDrown;
            return this;
        }

        public Properties fallDistanceModifier(float fallDistanceModifier) {
            this.fallDistanceModifier = fallDistanceModifier;
            return this;
        }

        public Properties canExtinguish(boolean canExtinguish) {
            this.canExtinguish = canExtinguish;
            return this;
        }

        public Properties canConvertToSource(boolean canConvertToSource) {
            this.canConvertToSource = canConvertToSource;
            return this;
        }

        public Properties supportsBoating(boolean supportsBoating) {
            this.supportsBoating = supportsBoating;
            return this;
        }

        public Properties pathType(@Nullable class_7 pathType) {
            this.pathType = pathType;
            return this;
        }

        public Properties adjacentPathType(@Nullable class_7 adjacentPathType) {
            this.adjacentPathType = adjacentPathType;
            return this;
        }

        public Properties sound(SoundAction action, class_3414 sound) {
            this.sounds.put(action, sound);
            return this;
        }

        public Properties canHydrate(boolean canHydrate) {
            this.canHydrate = canHydrate;
            return this;
        }

        public Properties lightLevel(int lightLevel) {
            if (lightLevel < 0 || lightLevel > 15) {
                throw new IllegalArgumentException("The light level should be between [0,15].");
            }
            this.lightLevel = lightLevel;
            return this;
        }

        public Properties density(int density) {
            this.density = density;
            return this;
        }

        public Properties temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Properties viscosity(int viscosity) {
            if (viscosity < 0) {
                throw new IllegalArgumentException("The viscosity should never be negative.");
            }
            this.viscosity = viscosity;
            return this;
        }

        public Properties rarity(class_1814 rarity) {
            this.rarity = rarity;
            return this;
        }
    }
}

